/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.controls.builtin;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.controls.ScreenControl;
import net.montoyo.wd.core.JSServerRequest;
import net.montoyo.wd.core.MissingPermissionException;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;

public class JSRequestControl
extends ScreenControl {
    public static final ResourceLocation id = new ResourceLocation("webdisplays:js_req");
    int reqId;
    JSServerRequest reqType;
    Object[] data;

    public JSRequestControl(int reqId, JSServerRequest reqType, Object[] data) {
        super(id);
        this.reqId = reqId;
        this.reqType = reqType;
        this.data = data;
    }

    public JSRequestControl(FriendlyByteBuf buf) {
        super(id);
        this.reqId = buf.readInt();
        this.reqType = JSServerRequest.fromID(buf.readByte());
        if (this.reqType != null) {
            this.data = this.reqType.deserialize(buf);
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.reqId);
        buf.writeByte(this.reqType.ordinal());
        if (!this.reqType.serialize(buf, this.data)) {
            throw new RuntimeException("Could not serialize CTRL_JS_REQUEST " + this.reqType);
        }
    }

    @Override
    public void handleServer(BlockPos pos, BlockSide side, TileEntityScreen tes, NetworkEvent.Context ctx, Function<Integer, Boolean> permissionChecker) throws MissingPermissionException {
        ServerPlayer player = ctx.getSender();
        if (this.reqType == null || this.data == null) {
            Log.warning("Caught invalid JS request from player %s (UUID %s)", player.m_7755_(), player.m_36316_().getId().toString());
        } else {
            tes.handleJSRequest(player, side, this.reqId, this.reqType, this.data);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(BlockPos pos, BlockSide side, TileEntityScreen tes, NetworkEvent.Context ctx) {
        throw new RuntimeException("TODO");
    }
}

